#version 150
#define MAX_STEPS 100
#define MAX_DIST 100.0
#define SURF_DIST 0.1
//By Z22
//Contains a bunch of code from ...
// "ShaderToy Tutorial - Ray Marching for Dummies!"
// by Martijn Steinrucken aka BigWings/CountFrolic - 2018
// License Creative Commons Attribution-NonCommercial-ShareAlike 3.0 Unported License.
//
// This shader is part of a tutorial on YouTube
// https://youtu.be/PGtv-dBi2wE
// https://www.shadertoy.com/view/XlGBW3

uniform sampler2D texture0;
uniform float u_Elapsed;
in vec4 gl_FragCoord ;
vec2 fragCoord = gl_FragCoord.xy;
in vec4 gl_TexCoord[];
vec4 vTexCoord = gl_TexCoord[0];
uniform vec2 textureSize0;
vec2 Offset = vec2(1.0) / textureSize0;
vec4 BG = texture2D(texture0, vTexCoord.xy);
vec2 uv = ((fragCoord-0.5*textureSize0.xy)/textureSize0.y)*1.5;

float smin( float a, float b, float k)
{
	float h = clamp(0.5+0.5*(b-a)/k, 0.0, 1.0);
	return mix(b,a,h)-k*h*(1.0-h);
}

float GetDist (vec3 p)
{

	vec4 sa = vec4(0.0+9.0*sin(u_Elapsed*0.9),0.0+5.0*cos(u_Elapsed*0.3),10+2.0*sin(u_Elapsed*0.26),1);
	vec4 sb = vec4(0.0-9.0*sin(u_Elapsed*0.1),0.0+5.0*cos(u_Elapsed*0.7),10+2.0*sin(u_Elapsed*0.25),1);
	vec4 sc = vec4(0.0+9.0*sin(u_Elapsed*0.4),0.0+5.0*cos(u_Elapsed*0.6),10+2.0*sin(u_Elapsed*0.24),1);
	vec4 sd = vec4(0.0-9.0*sin(u_Elapsed*0.1),0.0-5.0*cos(u_Elapsed*0.7),10+2.0*sin(u_Elapsed*0.23),1);
	vec4 se = vec4(0.0+9.0*sin(u_Elapsed*0.11),0.0-5.0*cos(u_Elapsed*0.22),10+2.0*sin(u_Elapsed*0.22),1);
	vec4 sf = vec4(0.0+9.0*sin(u_Elapsed*0.12),0.0-5.0*cos(u_Elapsed*0.45),10+2.0*sin(u_Elapsed*0.21),1);
	vec4 sg = vec4(0.0-9.0*sin(u_Elapsed*0.13),0.0+5.0*cos(u_Elapsed*0.83),10+2.0*sin(u_Elapsed*0.20),1);
	vec4 sh = vec4(0.0-9.0*sin(u_Elapsed*0.14),0.0+5.0*cos(u_Elapsed*0.64),10+2.0*sin(u_Elapsed*0.19),1);
	vec4 si = vec4(0.0+9.0*sin(u_Elapsed*0.15),0.0-5.0*cos(u_Elapsed*0.12),10+2.0*sin(u_Elapsed*0.18),1);
	vec4 sj = vec4(0.0+9.0*sin(u_Elapsed*0.16),0.0-5.0*cos(u_Elapsed*0.56),10+2.0*sin(u_Elapsed*0.17),1);
	vec4 sk = vec4(0.0+9.0*sin(u_Elapsed*0.17),0.0+5.0*cos(u_Elapsed*0.98),10+2.0*sin(u_Elapsed*0.16),1);
	vec4 sl = vec4(0.0-9.0*sin(u_Elapsed*0.18),0.0-5.0*cos(u_Elapsed*0.47),10+2.0*sin(u_Elapsed*0.15),1);
	vec4 sm = vec4(0.0-9.0*sin(u_Elapsed*0.19),0.0+5.0*cos(u_Elapsed*0.34),10+2.0*sin(u_Elapsed*0.14),1);
	vec4 sn = vec4(0.0-9.0*sin(u_Elapsed*0.20),0.0-5.0*cos(u_Elapsed*0.26),10+2.0*sin(u_Elapsed*0.13),1);
	vec4 so = vec4(0.0+9.0*sin(u_Elapsed*0.21),0.0+5.0*cos(u_Elapsed*0.38),10+2.0*sin(u_Elapsed*0.12),1);
	vec4 sp = vec4(0.0+9.0*sin(u_Elapsed*0.22),0.0+5.0*cos(u_Elapsed*0.15),10+2.0*sin(u_Elapsed*0.11),1);
	vec4 sq = vec4(0.0-9.0*sin(u_Elapsed*0.23),0.0-5.0*cos(u_Elapsed*0.25),10+2.0*sin(u_Elapsed*0.09),1);
	vec4 sr = vec4(0.0-9.0*sin(u_Elapsed*0.24),0.0-5.0*cos(u_Elapsed*0.65),10+2.0*sin(u_Elapsed*0.08),1);
	vec4 ss = vec4(0.0+9.0*sin(u_Elapsed*0.25),0.0-5.0*cos(u_Elapsed*0.53),10+2.0*sin(u_Elapsed*0.07),1);
	vec4 st = vec4(0.0-9.0*sin(u_Elapsed*0.26),0.0+5.0*cos(u_Elapsed*0.73),10+2.0*sin(u_Elapsed*0.06),1);

	float sda = distance(p,sa.xyz)-sa.w;
	float sdb = distance(p,sb.xyz)-sb.w;
	float sdc = distance(p,sc.xyz)-sc.w;
	float sdd = distance(p,sd.xyz)-sd.w;
	float sde = distance(p,se.xyz)-se.w;
	float sdf = distance(p,sf.xyz)-sf.w;
	float sdg = distance(p,sg.xyz)-sg.w;
	float sdh = distance(p,sh.xyz)-sh.w;
	float sdi = distance(p,si.xyz)-si.w;
	float sdj = distance(p,sj.xyz)-sj.w;
	float sdk = distance(p,sk.xyz)-sk.w;
	float sdl = distance(p,sl.xyz)-sl.w;
	float sdm = distance(p,sm.xyz)-sm.w;
	float sdn = distance(p,sn.xyz)-sn.w;
	float sdo = distance(p,so.xyz)-so.w;
	float sdp = distance(p,sp.xyz)-sp.w;
	float sdq = distance(p,sq.xyz)-sq.w;
	float sdr = distance(p,sr.xyz)-sr.w;
	float sds = distance(p,ss.xyz)-ss.w;
	float sdt = distance(p,st.xyz)-st.w;

	float sd1 = smin(sda,sdb,1.9);
	float sd2 = smin(sd1,sdc,1.9);
	float sd3 = smin(sd2,sdd,1.9);
	float sd4 = smin(sd3,sde,1.9);
	float sd5 = smin(sd4,sdf,1.9);
	float sd6 = smin(sd5,sdg,1.9);
	float sd7 = smin(sd6,sdh,1.9);
	float sd8 = smin(sd7,sdi,1.9);
	float sd9 = smin(sd8,sdj,1.9);
	float sd10 = smin(sd9,sdk,1.9);
	float sd11 = smin(sd10,sdl,1.9);
	float sd12 = smin(sd11,sdm,1.9);
	float sd13 = smin(sd12,sdn,1.9);
	float sd14 = smin(sd13,sdo,1.9);
	float sd15 = smin(sd14,sdp,1.9);
	float sd16 = smin(sd15,sdq,1.9);
	float sd17 = smin(sd16,sdr,1.9);
	float sd18 = smin(sd17,sds,1.9);
	float sd19 = smin(sd18,sdt,1.9);

	return sd19;
}

float RayMarch(vec3 ro, vec3 rd)
{
	float dO=0.0;

	for(int i=0; i<MAX_STEPS; i++)
	{
		vec3 p = ro + rd*dO;
		float dS = GetDist(p);
		dO += dS;
		if(dO>MAX_DIST || dS<SURF_DIST) break;
	}
	return dO;
}

vec3 GetNormal (vec3 p)
{
	float d = GetDist(p);
	vec2 e = vec2(0.001,0.0);

	vec3 n = d - vec3(GetDist(p-e.xyy),GetDist(p-e.yxy),GetDist(p-e.yyx));

	return normalize(n);
}

float GetLight (vec3 p)
{
	vec3 lightPos = vec3(0.0,0.0,6.0);
	lightPos.xy += vec2( 4.0*sin(u_Elapsed), 4.0*cos(u_Elapsed));
	vec3 l = normalize(lightPos-p);
	vec3 n = GetNormal(p);

	float dif = clamp(dot(n,l),0.0,1.0);
	return dif;
}

vec3 GetRefract (vec3 p, vec3 n)
{
	vec3 AoI  = vec3( p.x, p.y, -70.0);
	vec3 OutV = vec3( n.x, n.y, n.z ) ;
	vec3 IoR  = vec3(1.45 , 1.55 , 1.65  );
	vec3 refR = (refract(AoI.xyz, OutV.rgb, IoR.r));
	vec3 refG = (refract(AoI.xyz, OutV.rgb, IoR.g));
	vec3 refB = (refract(AoI.xyz, OutV.rgb, IoR.b));
	vec3 col;
	col.r = texture2D(texture0, vTexCoord.xy +Offset*vec2(refR.x,refR.y)).r;
	col.g = texture2D(texture0, vTexCoord.xy +Offset*vec2(refG.x,refG.y)).g;
	col.b = texture2D(texture0, vTexCoord.xy +Offset*vec2(refB.x,refB.y)).b;
	return (col);
}

void main(void)
{


	vec3 ro = vec3(0.0, 0.0, 0.0);
	vec3 rd = normalize(vec3(uv.x, uv.y, 1.0));
	float d = RayMarch(ro, rd);
	vec3 p = ro + rd * d;
	vec3 n = GetNormal(p);
	vec3 col = GetRefract(rd,n);
	
gl_FragColor = vec4( col, 1.0);
gl_FragColor.a = length(gl_FragColor.rgb); //renders alpha transparency
}
